package easik.ui.menu;

import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;
import javax.swing.JOptionPane;

import easik.Easik;
import easik.states.AddProductConstraintState;


/**
 * Action for the menu option used to create product constraints.
 * 
 * @author Rob Fletcher 2005
 * @author Kevin Green 2006
 * @version 2006-06-13 Kevin Green
 */
public class AddProductConstraintAction extends AbstractAction {

	/**
	 * Create the action and set the name and description.
	 */
	public AddProductConstraintAction() {
		super();
		putValue(AbstractAction.NAME, "Add a Product Constraint");
		putValue(
			AbstractAction.SHORT_DESCRIPTION,
			"Create a product constraint from a set of paths");
	}

	/**
	 * When the action is performed, attempt to create a product constraint after
	 * validating the selection.
	 * 
	 * @param e The action event
	 */
	public void actionPerformed(ActionEvent e) {
		if(!Easik.getInstance().getFrame().getSketch().getEntities().isEmpty()){
			Easik.getInstance().getStateManager().pushState(
				new AddProductConstraintState(Easik.getInstance().getFrame().getSketch()));
		}
		else{
			JOptionPane.showMessageDialog(null, "Sketch cannot be empty.", "Error", JOptionPane.ERROR_MESSAGE);
		}
	}
}
